var DAY_ARRAY = new Array("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");

var use24HR = true;

var cityName = "Philadelphia";
var offsetFromNow = -13;

function setup()
{
	displayLocation();

  document.getElementById('nameField').value=cityName;
  document.getElementById('offsetField').value=offsetFromNow;

	timeLoop();

	return 0;
}

function timeLoop() {
	time = getOffsetTime();
	
	displayTime(formatTime(time));

	setTimeout ('timeLoop()',1000);
}

function getOffsetTime() {
  var now = new Date();
	var targetGMTOffset;
  
  now.setTime(now.getTime() + ((offsetFromNow * 60) * 60 * 1000));

	return now;
}

function formatTime(time) {
	var padMinutes = "";
	var padSeconds= "";
	var hours = time.getHours();
	var amPm = "";

	if (time.getMinutes() < 10) {
		padMinutes = "0";
	}

	if (time.getSeconds() < 10) {
		padSeconds = "0";
	}

	if (use24HR == false) {
		if (hours > 12) {
			amPm = "p";
		} else {
			amPm = "a";
		}

		hours %= 12;

		if (hours == 0) {
			hours = 12;
		}
	}	
		
	return DAY_ARRAY[time.getDay()] + " " + String(hours) + ":" + padMinutes + String(time.getMinutes()) + amPm;
	//The line below will display seconds
	/* return DAY_ARRAY[time.getDay()] + " " + String(time.getHours()) + ":" + padMinutes + String(time.getMinutes()) + ":" + padSeconds + String(time.getSeconds()); */
}

function displayTime(time)
{
	document.getElementById('time').firstChild.data=time;
}

function displayLocation()
{
	document.getElementById('location').firstChild.data=cityName;
}

function updatePrefs() {
  cityName = document.getElementById('nameField').value;
  offsetFromNow = parseInt(document.getElementById('offsetField').value);

	displayLocation();
}

function doneClicked() {
	updatePrefs();

	hidePrefs();
}
	
